//+------------------------------------------------------------------+
//|                                                     Weekly Pivot |
//|                                    Copyright  2006, Profitrader |
//|                                    Coded/Verified by Profitrader |
//+------------------------------------------------------------------+
//
// Modified for 10.2 by nanningbob April 2012
// Modified by candletiger@forexfactory April 2012
// Version ct4
//+------------------------------------------------------------------+
//| Supported features/additions/modifications:                      |
//| * paints pivot lines for *every* week or month in history        |
//| * paints 3 S/L levels                                            |
//| * with a second instance, mid lines can be added                 |
//| * for the current week/month, an extension line is drawn         |
//| * added text paramters to the options                            |
//| * added colors to the options                                    |
//|                                                                  |
//+------------------------------------------------------------------+

#property copyright "Copyright  2006, Profitrader."
#property link      "profitrader@inbox.ru"

#property indicator_chart_window
#property indicator_buffers 7

extern string wmtext1                = "pivot timeframe";
extern string wmtext2                = "weeky=1, monthly=2";
extern int    pivot_timeframe        = 1;
extern string mltext1                = "first instance supports main pivot levels";
extern string mltext2                = "to add mid pivot levels, load this";
extern string mltext3                = "indicator a second time and set below true";
extern bool   addMidLevels           = false;
extern string bartext                = "set to number of bars to use";
extern int    BarsToProcess          = 200;
extern string linetext               = "below line/text style is configured";
extern string text_font              = "Arial";
extern int    text_size              = 7;
extern color  text_color             = Red;
extern string tstext1                = "text_shift shifts the line text by N spaces";
extern int    text_shift             = 30;
extern int    line_thickness_main    = 2;
extern int    line_thickness_mid     = 1;
extern color  line_color_main        = Black;           // Black
extern color  line_color_support1    = DodgerBlue;      // DodgerBlue
extern color  line_color_resistance1 = OrangeRed;       // OrangeRed
extern color  line_color_support2    = White;           // RoyalBlue
extern color  line_color_resistance2 = White;           // Crimson
extern color  line_color_support3    = White;           // Blue
extern color  line_color_resistance3 = White;           // Maroon

//---- buffers
double PBuffer[];
double S1Buffer[];
double R1Buffer[];
double S2Buffer[];
double R2Buffer[];
double S3Buffer[];
double R3Buffer[];

//---- global variables
datetime current_time;
double   multiplier;
double   last_high,last_low,last_close;
double   P,S1,R1,S2,R2,S3,R3, MS1, MS2, MS3, MR1, MR2, MR3, dP,dS1,dR1,dS2,dR2,dS3,dR3;
int      i;
int      line_thickness;
int      pivot_bar;
int      pivot_timeframe_const;
string   pregap = "";
string   timeframe_prefix;
string   timeframe_prefix_text;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
/*
    //Accommodate different quote sizes
    double multiplier;
    if(Digits == 2 || Digits == 4) multiplier = 1;
    if(Digits == 3 || Digits == 5) multiplier = 10;
    if(Digits == 6) multiplier = 100;   

*/
   //Accommodate different quote sizes
   if(StringFind(Symbol(),"JPY",0)<0)  multiplier = 10000;
   if(StringFind(Symbol(),"JPY",0)>=0) multiplier = 100;
  
   SetIndexBuffer(0,PBuffer);
   SetIndexBuffer(1,S1Buffer);
   SetIndexBuffer(2,R1Buffer);
   SetIndexBuffer(3,S2Buffer);
   SetIndexBuffer(4,R2Buffer);
   SetIndexBuffer(5,S3Buffer);
   SetIndexBuffer(6,R3Buffer);
   
   if(addMidLevels == true) line_thickness = line_thickness_mid;
   else line_thickness = line_thickness_main;
   
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,line_thickness, line_color_main);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,line_thickness, line_color_support1);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,line_thickness, line_color_resistance1);
   SetIndexStyle(3,DRAW_LINE,STYLE_SOLID,line_thickness, line_color_support2);
   SetIndexStyle(4,DRAW_LINE,STYLE_SOLID,line_thickness, line_color_resistance2);
   SetIndexStyle(5,DRAW_LINE,STYLE_SOLID,line_thickness, line_color_support3);
   SetIndexStyle(6,DRAW_LINE,STYLE_SOLID,line_thickness, line_color_resistance3);

   if( pivot_timeframe == 1) pivot_timeframe_const = PERIOD_W1;
   if( pivot_timeframe == 2) pivot_timeframe_const = PERIOD_MN1;
   
   if(pivot_timeframe == 1) timeframe_prefix = "Weekly ";
   if(pivot_timeframe == 2) timeframe_prefix = "Monthly ";

   pregap="";   
   for(i=0; i<text_shift;i++) pregap = pregap + " ";
   if(addMidLevels == true) timeframe_prefix = timeframe_prefix + "Mid ";
   timeframe_prefix_text = pregap + timeframe_prefix;
      
   SetIndexLabel(0,timeframe_prefix + "Pivot Point");
   SetIndexLabel(1,timeframe_prefix + "Support 1");
   SetIndexLabel(2,timeframe_prefix + "Resistance 1");
   SetIndexLabel(3,timeframe_prefix + "Support 2");
   SetIndexLabel(4,timeframe_prefix + "Resistance 2");
   SetIndexLabel(5,timeframe_prefix + "Support 3");
   SetIndexLabel(6,timeframe_prefix + "Resistance 3");
   
   //the line text objects
   ObjectCreate(timeframe_prefix + "Pivot",OBJ_TEXT,0,0,0);
   ObjectSetText(timeframe_prefix + "Pivot",timeframe_prefix_text + "Pivot", text_size, text_font, text_color);
   ObjectCreate(timeframe_prefix + "Res1",OBJ_TEXT,0,0,0);
   ObjectSetText(timeframe_prefix + "Res1",timeframe_prefix_text + "Res1", text_size, text_font, text_color);
   ObjectCreate(timeframe_prefix + "Sup1",OBJ_TEXT,0,0,0);
   ObjectSetText(timeframe_prefix + "Sup1",timeframe_prefix_text + "Sup1", text_size, text_font, text_color);
   ObjectCreate(timeframe_prefix + "Res2",OBJ_TEXT,0,0,0);
   ObjectSetText(timeframe_prefix + "Res2",timeframe_prefix_text + "Res2", text_size, text_font, text_color);
   ObjectCreate(timeframe_prefix + "Sup2",OBJ_TEXT,0,0,0);
   ObjectSetText(timeframe_prefix + "Sup2",timeframe_prefix_text + "Sup2", text_size, text_font, text_color);
   ObjectCreate(timeframe_prefix + "Res3",OBJ_TEXT,0,0,0);
   ObjectSetText(timeframe_prefix + "Res3",timeframe_prefix_text + "Res3", text_size, text_font, text_color);
   ObjectCreate(timeframe_prefix + "Sup3",OBJ_TEXT,0,0,0);
   ObjectSetText(timeframe_prefix + "Sup3",timeframe_prefix_text + "Sup3", text_size, text_font, text_color);
   
   // the current pivot lines extension
   // why this? Beginning of a new week or month, the index lines are almost not visible
   // to compensate, we print a dotted helper line (Trend line, not an index line) from the current bar to the end
   ObjectCreate(timeframe_prefix + "Pivot ext", OBJ_TREND,0, 0,0,0,0);
   ObjectSet(timeframe_prefix + "Pivot ext", OBJPROP_COLOR, line_color_main);
   ObjectSet(timeframe_prefix + "Pivot ext", OBJPROP_STYLE, STYLE_DOT);
   ObjectCreate(timeframe_prefix + "Res1 ext", OBJ_TREND,0, 0,0,0,0);
   ObjectSet(timeframe_prefix + "Res1 ext", OBJPROP_COLOR, line_color_resistance1);
   ObjectSet(timeframe_prefix + "Res1 ext", OBJPROP_STYLE, STYLE_DOT);
   ObjectCreate(timeframe_prefix + "Sup1 ext", OBJ_TREND,0, 0,0,0,0);
   ObjectSet(timeframe_prefix + "Sup1 ext", OBJPROP_COLOR, line_color_support1);
   ObjectSet(timeframe_prefix + "Sup1 ext", OBJPROP_STYLE, STYLE_DOT);
   ObjectCreate(timeframe_prefix + "Res2 ext", OBJ_TREND,0, 0,0,0,0);
   ObjectSet(timeframe_prefix + "Res2 ext", OBJPROP_COLOR, line_color_resistance2);
   ObjectSet(timeframe_prefix + "Res2 ext", OBJPROP_STYLE, STYLE_DOT);
   ObjectCreate(timeframe_prefix + "Sup2 ext", OBJ_TREND,0, 0,0,0,0);
   ObjectSet(timeframe_prefix + "Sup2 ext", OBJPROP_COLOR, line_color_support2);
   ObjectSet(timeframe_prefix + "Sup2 ext", OBJPROP_STYLE, STYLE_DOT);
   ObjectCreate(timeframe_prefix + "Res3 ext", OBJ_TREND,0, 0,0,0,0);
   ObjectSet(timeframe_prefix + "Res3 ext", OBJPROP_COLOR, line_color_resistance3);
   ObjectSet(timeframe_prefix + "Res3 ext", OBJPROP_STYLE, STYLE_DOT);
   ObjectCreate(timeframe_prefix + "Sup3 ext", OBJ_TREND,0, 0,0,0,0);
   ObjectSet(timeframe_prefix + "Sup3 ext", OBJPROP_COLOR, line_color_support3);
   ObjectSet(timeframe_prefix + "Sup3 ext", OBJPROP_STYLE, STYLE_DOT);
      
   return(0);
}

//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   ObjectDelete(timeframe_prefix + "Pivot");
   ObjectDelete(timeframe_prefix + "Sup1");
   ObjectDelete(timeframe_prefix + "Res1");
   ObjectDelete(timeframe_prefix + "Sup2");
   ObjectDelete(timeframe_prefix + "Res2");
   ObjectDelete(timeframe_prefix + "Sup3");
   ObjectDelete(timeframe_prefix + "Res3"); 
   
   ObjectDelete(timeframe_prefix + "Pivot ext"); 
   ObjectDelete(timeframe_prefix + "Res1 ext"); 
   ObjectDelete(timeframe_prefix + "Res2 ext"); 
   ObjectDelete(timeframe_prefix + "Res3 ext"); 
   ObjectDelete(timeframe_prefix + "Sup1 ext"); 
   ObjectDelete(timeframe_prefix + "Sup2 ext"); 
   ObjectDelete(timeframe_prefix + "Sup3 ext"); 
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int i,counted_bars=IndicatorCounted();
   //---- check for possible errors
   if(counted_bars<0) return(-1);
   //---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;  
   int Limit=Bars-counted_bars;
   
   if(pivot_timeframe == 1) if(Period()>PERIOD_D1) return(-1);
   if(pivot_timeframe == 2) if(Period()>PERIOD_W1) return(-1);

   if(Limit>BarsToProcess) Limit=BarsToProcess;
   for(i=Limit-1; i>=0; i--)
   {
       // looking for the current time   
       current_time = Time[i];
       // and seach the corresponding bar in the pivot timeframe
       pivot_bar = iBarShift( NULL, pivot_timeframe_const, current_time);
       // read the values of that previous week/month
       last_low=iLow(NULL, pivot_timeframe_const, pivot_bar+1);
       last_high=iHigh(NULL, pivot_timeframe_const, pivot_bar+1);
       last_close=iClose(NULL, pivot_timeframe_const, pivot_bar+1);
       
       // calculate main pivot and S/R lines		    
       P=(last_high+last_low+last_close)/3;
       R1=(2*P)-last_low;
       S1=(2*P)-last_high;
       R2=P+(last_high-last_low);
       S2=P-(last_high-last_low);
       R3=(2*P)+(last_high-(2*last_low));
       S3=(2*P)-((2*last_high)-last_low);
       
       // calculate mid S/R lines		    
       MS3 = S3 + ((S2-S3) / 2);
       MS2 = S2 + ((S1-S2) / 2);
       MS1 = S1 + ((P-S1) / 2);
       MR1 = P + ((R1-P) / 2);
       MR2 = R1 + ((R2-R1) / 2);
       MR3 = R2 + ((R3-R2) / 2);
       
       // copy either main or mid values to the temp display variables
       if( addMidLevels == false)
       {
         dP=P;
         dS1=S1;
         dR1=R1;
         dS2=S2;
         dR2=R2;
         dS3=S3;
         dR3=R3;
       }
       else
       {
         dP=0;
         dS1=MS1;
         dR1=MR1;
         dS2=MS2;
         dR2=MR2;
         dS3=MS3;
         dR3=MR3;
      }
    
       PBuffer[i]=dP;
       S1Buffer[i]=dS1;
       R1Buffer[i]=dR1;
       S2Buffer[i]=dS2;
       R2Buffer[i]=dR2;
       S3Buffer[i]=dS3;
       R3Buffer[i]=dR3;
    } // end for i loop
    
    pregap = "";   
    for(i=0; i<text_shift;i++) pregap = pregap + " ";
    if(addMidLevels == true) timeframe_prefix = timeframe_prefix + "Mid ";
    timeframe_prefix_text = pregap + timeframe_prefix;
      
    // move the text to the current bar
    ObjectMove(timeframe_prefix + "Pivot",0,Time[0],dP);
    ObjectSetText(timeframe_prefix + "Pivot", timeframe_prefix_text + "Pivot ("+DoubleToStr((dP-Close[0]) * multiplier, 1)+" pts)");        
    ObjectMove(timeframe_prefix + "Sup1",0,Time[0],dS1);
    ObjectSetText(timeframe_prefix + "Sup1", timeframe_prefix_text + "Sup1 ("+DoubleToStr((dS1-Close[0]) * multiplier, 1)+" pts)");    
    ObjectMove(timeframe_prefix + "Res1",0,Time[0],dR1);
    ObjectSetText(timeframe_prefix + "Res1", timeframe_prefix_text + "Res1 ("+DoubleToStr((dR1-Close[0]) * multiplier, 1)+" pts)");            
    ObjectMove(timeframe_prefix + "Sup2",0,Time[0],dS2);
    ObjectSetText(timeframe_prefix + "Sup2", timeframe_prefix_text + "Sup2 ("+DoubleToStr((dS2-Close[0]) * multiplier, 1)+" pts)");                
    ObjectMove(timeframe_prefix + "Res2",0,Time[0],dR2);
    ObjectSetText(timeframe_prefix + "Res2", timeframe_prefix_text + "Res2 ("+DoubleToStr((dR2-Close[0]) * multiplier, 1)+" pts)");                    
    ObjectMove(timeframe_prefix + "Sup3",0,Time[0],dS3);
    ObjectSetText(timeframe_prefix + "Sup3", timeframe_prefix_text + "Sup3 ("+DoubleToStr((dS3-Close[0]) * multiplier, 1)+" pts)");                        
    ObjectMove(timeframe_prefix + "Res3",0,Time[0],dR3);
    ObjectSetText(timeframe_prefix + "Res3", timeframe_prefix_text + "Res3 ("+DoubleToStr((dR3-Close[0]) * multiplier, 1)+" pts)");                            
   
    // move the helper extension lines to the current bar
    ObjectMove(timeframe_prefix + "Pivot ext", 0, Time[1],dP);
    ObjectMove(timeframe_prefix + "Pivot ext", 1, Time[0],dP);
    ObjectMove(timeframe_prefix + "Res1 ext", 0, Time[1],dR1);
    ObjectMove(timeframe_prefix + "Res1 ext", 1, Time[0],dR1);
    ObjectMove(timeframe_prefix + "Res2 ext", 0, Time[1],dR2);
    ObjectMove(timeframe_prefix + "Res2 ext", 1, Time[0],dR2);
    ObjectMove(timeframe_prefix + "Res3 ext", 0, Time[1],dR3);
    ObjectMove(timeframe_prefix + "Res3 ext", 1, Time[0],dR3);
    ObjectMove(timeframe_prefix + "Sup1 ext", 0, Time[1],dS1);
    ObjectMove(timeframe_prefix + "Sup1 ext", 1, Time[0],dS1);
    ObjectMove(timeframe_prefix + "Sup2 ext", 0, Time[1],dS2);
    ObjectMove(timeframe_prefix + "Sup2 ext", 1, Time[0],dS2);
    ObjectMove(timeframe_prefix + "Sup3 ext", 0, Time[1],dS3);
    ObjectMove(timeframe_prefix + "Sup3 ext", 1, Time[0],dS3);
    
    //----
    return(0);
}
//+------------------------------------------------------------------+

